﻿#reference Tessa.Extensions.WorkflowExamples.Shared
#using Tessa.Extensions.WorkflowExamples.Shared.Workflow;

public async Task FillRenouncementParamsAsync(CardTask task)
{
    var card = await this.GetCardAsync();
	card.WfeLACommonInfo.CauseRenouncementRefID = task.Card.DynamicEntries.WfeTasksCommonInfo.CauseRenouncementRefID;
	card.WfeLACommonInfo.CauseRenouncementRefName = task.Card.DynamicEntries.WfeTasksCommonInfo.CauseRenouncementRefName;
	card.WfeLACommonInfo.CauseRenouncementCom = task.Card.DynamicEntries.WfeTasksCommonInfo.CauseRenouncement;
	card.WfeLACommonInfo.StepRenouncementID = card.WfeLACommonInfo.ProcessStepID;
	card.WfeLACommonInfo.StepRenouncementName = card.WfeLACommonInfo.ProcessStepName;
}

public void FillRevokeParams(CardTask task)
{
	Signal.IsRevoke = true;
}

public void FillExpertiseParams(CardTask task, ExpertiseTypes expertiseType)
{
	Signal.ExpertDepartmentID = task.Card.DynamicEntries.WfeTasksCommonInfo.ExpertDepartmentID;
	Signal.ExpertDepartmentName = task.Card.DynamicEntries.WfeTasksCommonInfo.ExpertDepartmentName;
	Signal.Segment = Process.Segment;
	Signal.ExpertiseType = expertiseType;
}

public async Task SetSalesSupervisorAsync(CardTask task)
{
	var db = DbScope.Db;
	
	await db.SetCommand(
		DbScope.BuilderFactory
			.Update("WfeLACommonInfo")
				.C("SalesSupervisorID").Equals().P("SalesSupervisorID")
				.C("SalesSupervisorName").Equals().P("SalesSupervisorName")
			.Where()
				.C("ID").Equals().P("CardID")
			.Build(),
		db.Parameter("SalesSupervisorID", (Guid?)task.Card.DynamicEntries.WfeTasksCommonInfo.SalesSupervisorID),
		db.Parameter("SalesSupervisorName", (string)task.Card.DynamicEntries.WfeTasksCommonInfo.SalesSupervisorName),
		db.Parameter("CardID", CardID))
		.LogCommand()
		.ExecuteNonQueryAsync();
}

public async Task SetCreditAnalystAsync(CardTask task)
{	
	var db = DbScope.Db;
	
	await db.SetCommand(
		DbScope.BuilderFactory
			.Update("WfeLACommonInfo")
				.C("CreditAnalystID").Equals().P("CreditAnalystID")
				.C("CreditAnalystName").Equals().P("CreditAnalystName")
			.Where()
				.C("ID").Equals().P("CardID")
			.Build(),
		db.Parameter("CreditAnalystID", (Guid?)task.Card.DynamicEntries.WfeTasksCommonInfo.CreditAnalystID),
		db.Parameter("CreditAnalystName", (string)task.Card.DynamicEntries.WfeTasksCommonInfo.CreditAnalystName),
		db.Parameter("CardID", CardID))
		.LogCommand()
		.ExecuteNonQueryAsync();
}